export const USE_PLAYER_NAMES = true;

// during debug, when NFC is inactive, we'll display animals for players to click on instead
// when true, the animal temperaments will be visible, making the game VERY easy
// then false, players will have to rely on guessing and their memory
// note: this can be overriden per session by the config
export const DEBUG_DISPLAY_ALL_TEMPERAMENTS = 0;

// during debug, instructs the code to randomly assign some animals to players
// Note: this just makes an animal unavailable, it doesn't update the player's count
export const DEBUG_RANDOMLY_ASSIGN_FRIENDS = false;
export const DEBUG_RANDOMLY_ASSIGN_FRIENDS_TOTAL = 10;

// during debug, display a table showing the current treats for each player
export const DEBUG_DISPLAY_TREAT_TABLE = true;

// during debug, force every animal interaction to result in friendship (set one)
export const DEBUG_EVERY_INTERACTION_IS_FRIENDSHIP = false;

// during debug, force every animal interaction to result in a bite (set one)
export const DEBUG_EVERY_INTERACTION_IS_A_BITE = false;

// during debug, if needed, disable NFC
// note: this can be overriden per session by the config
export const DEBUG_NFC_DISABLED = 0;

// specify the NFC collection and set to use
export const NFC_COLLECTION = 'animals';
export const NFC_SET = 'white';

export const PLACEHOLDER_SVG = `data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1333 1512">
<rect width="1333" height="1512" fill="%23f0f0f0"/>
<circle cx="666.5" cy="756" r="300" fill="%23e0e0e0"/>
<ellipse cx="566.5" cy="706" rx="30" ry="40" fill="%23333"/>
<ellipse cx="766.5" cy="706" rx="30" ry="40" fill="%23333"/>
<path d="M616.5 806 Q666.5 856 716.5 806" fill="none" stroke="%23333" stroke-width="10" stroke-linecap="round"/>
<text x="666.5" y="1156" font-family="Arial, sans-serif" font-size="48" text-anchor="middle" fill="%23666">Image Not Found</text>
</svg>`;

// Game States
export const GameStates = {
    TitleScreen: 1,
    PlayerSelection: 2,
    Started: 3,
    Running: 4,
    Ended: 5
};

export const GameStateMessages = {
    [GameStates.TitleScreen]: "Title Screen",
    [GameStates.PlayerSelection]: "Player Selection",
    [GameStates.Started]: "Game Has Started",
    [GameStates.Running]: "Game In Progress",
    [GameStates.Ended]: "Game Over"
};

// Player States
export const PlayerStates = {
    TreatSelection: 1,
    AnimalSelection: 2,
    AnimalStats: 3,
    Collect: 4
};

export const PlayerStateMessages = {
    [PlayerStates.TreatSelection]: "Treat Selection",
    [PlayerStates.AnimalSelection]: "Animal Selection",
    [PlayerStates.AnimalStats]: "Animal Stats",
    [PlayerStates.Collect]: "Collect Animal"
};

// Animal Interactions
export const AnimalInteractions = {
    Nothing: 1,
    NewFriend: 2,
    NewBite: 3
};

export const AnimalInteractionMessages = {
    [AnimalInteractions.Nothing]: "Nothing Happened",
    [AnimalInteractions.NewFriend]: "New Friend",
    [AnimalInteractions.NewBite]: "New Bite"
};

// Game Ending Conditions
export const GameEndingConditions = {
    NoTreatsRemaining: 1,
    AllPlayersReachedMaxBites: 2,
    NoPlayableAnimalsLeft: 3
};

export const GameEndingMessages = {
    [GameEndingConditions.NoTreatsRemaining]: "No Treats Remaining",
    [GameEndingConditions.AllPlayersReachedMaxBites]: "All Players Reached Max Bites",
    [GameEndingConditions.NoPlayersCanTakeATurn]: "No Players Can Take a Turn",
    [GameEndingConditions.NoPlayableAnimalsLeft]: "No Playable Animals Remaining"
};

// Animal Interactions
export const ClickTargets = {
    AnimalSelection: 1,
    NextPlayer: 2
};

export const ClickTargetMessages = {
    [ClickTargets.AnimalSelection]: "Select an Animal",
    [ClickTargets.NextPlayer]: "Next Player"
};