export class TreatsTable {
    constructor(containerId = 'extended-info') {
      this.containerId = containerId;
      this.container = null;
      this.treats = [];
      this.initStyles();
    }
  
    initStyles() {
      if (!document.getElementById('treats-table-styles')) {
        const style = document.createElement('style');
        style.id = 'treats-table-styles';
        style.textContent = `
          .treats-table {
            border-collapse: collapse;
            width: 100%;
            max-width: 800px;
            margin: 20px 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            font-size: 14px;
            line-height: 1.4;
          }
  
          .treats-table th,
          .treats-table td {
            border: 1px solid #ddd;
            padding: 12px;
          }
  
          .treats-table th {
            background-color: #2c3e50;
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 13px;
          }
  
          .treats-table th:nth-child(1),
          .treats-table th:nth-child(2) {
            text-align: center;
          }
  
          .treats-table th:nth-child(3) {
            text-align: left;
          }
  
          .treats-table td.player-number {
            text-align: center;
            font-weight: 500;
            width: 80px;
          }
  
          .treats-table td.treat-value {
            text-align: center;
            width: 80px;
            font-family: 'Consolas', monospace;
          }
          
          .treats-table td.treat-name {
            width: max-content;
            white-space: nowrap;
          }
  
          .treats-table tr.player-group-even {
            background-color: #f8f9fa;
          }
  
          .treats-table tr:hover {
            background-color: #f0f0f0;
          }
  
          .empty-row {
            color: #999;
            font-style: italic;
          }
        `;
        document.head.appendChild(style);
      }
    }
  
    setTreats(treats) {
      this.treats = treats;
      return this;
    }
  
    setContainer(containerId) {
      this.containerId = containerId;
      return this;
    }
  
    render() {
      this.container = document.getElementById(this.containerId);
      if (!this.container) {
        throw new Error(`Container element with id "${this.containerId}" not found`);
      }
  
      // Clear existing content
      this.container.innerHTML = '';
  
      // Create table
      const table = document.createElement('table');
      table.className = 'treats-table';
  
      // Create header
      const thead = document.createElement('thead');
      const headerRow = document.createElement('tr');
      const headers = ['Player', 'Value', 'Treat'];
      headers.forEach(text => {
        const th = document.createElement('th');
        th.textContent = text;
        headerRow.appendChild(th);
      });
      thead.appendChild(headerRow);
      table.appendChild(thead);
  
      // Create body
      const tbody = document.createElement('tbody');
      
      this.treats.forEach((playerTreats, index) => {
        const playerNumber = index + 1;
        const isEvenPlayer = playerNumber % 2 === 0;
        
        if (!playerTreats || playerTreats.length === 0) {
          // Handle empty player treats
          const emptyRow = document.createElement('tr');
          if (isEvenPlayer) {
            emptyRow.className = 'player-group-even';
          }
          
          const playerCell = document.createElement('td');
          const valueCell = document.createElement('td');
          const treatsCell = document.createElement('td');
          
          playerCell.textContent = playerNumber;
          playerCell.className = 'player-number';
          valueCell.className = 'treat-value';
          valueCell.textContent = '-';
          treatsCell.textContent = 'No treats';
          treatsCell.className = 'empty-row';
          
          emptyRow.appendChild(playerCell);
          emptyRow.appendChild(valueCell);
          emptyRow.appendChild(treatsCell);
          tbody.appendChild(emptyRow);
        } else {
          // Create a row for each treat
          playerTreats.forEach((treat, treatIndex) => {
            const row = document.createElement('tr');
            if (isEvenPlayer) {
              row.className = 'player-group-even';
            }
            
            const playerCell = document.createElement('td');
            const valueCell = document.createElement('td');
            const treatsCell = document.createElement('td');
            
            // Only show player number in first row for this player
            playerCell.textContent = treatIndex === 0 ? playerNumber : '';
            playerCell.className = 'player-number';
            
            valueCell.textContent = treat.value;
            valueCell.className = 'treat-value';
            
            treatsCell.textContent = treat.name;
            treatsCell.className = 'treat-name';
            
            row.appendChild(playerCell);
            row.appendChild(valueCell);
            row.appendChild(treatsCell);
            tbody.appendChild(row);
          });
        }
      });
  
      table.appendChild(tbody);
      this.container.appendChild(table);
      return this;
    }
  }