function assignNameToAnimal(animalObj, namesData) {
    const animalType = animalObj.type;
    if (!namesData[animalType]) {
        throw new Error(`No names available for animal type: ${animalType}`);
    }
    
    const availableNames = namesData[animalType];
    const randomNameData = availableNames[Math.floor(Math.random() * availableNames.length)];
    
    return {
        ...animalObj,
        name: randomNameData.name,
        pronoun: randomNameData.gender === 'female' ? 'her' : 'his'
    };
}

// Example usage:
const animal = {
    name: "Marshmallow",
    type: "bunny",
    pronoun: "her",
    temperament: [],
    snarlish: false,
    startingNumber: null,
    friendOf: null,
    image: "bunny.png"
};

const updatedAnimal = assignNameToAnimal(animal, animalNames);
console.log(updatedAnimal);

// For multiple animals in an object:
function assignNamesToAllAnimals(animalsObj, namesData) {
    return Object.fromEntries(
        Object.entries(animalsObj).map(([id, animal]) => [
            id,
            assignNameToAnimal(animal, namesData)
        ])
    );
}
