import { 
	DEBUG_NFC_DISABLED
} from './GameConstants.js';

export class NFC {

    active = null;

    scanButtonGenerated = false;
    
    hiddenElementID = null;
    startElementID = null;

    fillElementID =  null;

    tags = [

        /* animals */
		{ sn: "04:64:6b:62:4a:6e:80", type: "bunny", collection: "animals", set: "black" },
		{ sn: "04:ad:6b:62:4a:6e:80", type: "cat", collection: "animals", set: "black"  },        
        { sn: "04:b3:6b:62:4a:6e:80", type: "owl", collection: "animals", set: "black"  },
        { sn: "04:90:d1:b8:78:00:00", type: "penguin", collection: "animals", set: "black"  },
        { sn: "04:63:6b:62:4a:6e:80", type: "bear", collection: "animals", set: "black"  },        
        { sn: "04:8e:d1:b8:78:00:00", type: "puppy", collection: "animals", set: "black"  },        
        { sn: "04:91:d1:b8:78:00:00", type: "koala", collection: "animals", set: "black"  },
        { sn: "04:5d:6b:62:4a:6e:80", type: "baby chick", collection: "animals", set: "black"  },        
        { sn: "04:50:6b:62:4a:6e:80", type: "swan", collection: "animals", set: "black"  },        
        { sn: "04:8d:d1:b8:78:00:00", type: "porcupine", collection: "animals", set: "black"  },        
        { sn: "04:4a:6b:62:4a:6e:80", type: "squirrel", collection: "animals", set: "black"  },        
        { sn: "04:01:d2:b8:78:00:00", type: "seal", collection: "animals", set: "black"  },        
        { sn: "04:8f:d1:b8:78:00:00", type: "sheep", collection: "animals", set: "black"  }, 
            {
              "sn": "04:fb:88:68:5f:61:80",
              "type": "fox",
              "collection": "animals",
              "set": "black" 
            },
            {
              "sn": "04:f5:f7:58:6f:61:80",
              "type": "sheep",
              "collection": "animals",
              "set": "black"
            },

        /* white set */
        { sn: "04:90:12:01:7b:48:03", type: "bunny", collection: "animals", set: "white" },
        { sn: "04:02:ec:01:21:47:03", type: "puppy", collection: "animals", set: "white"  }, 
        { sn: "04:b1:c8:01:4d:42:03", type: "swan", collection: "animals", set: "white"  },   
        { sn: "04:d3:12:01:b8:44:03", type: "cat", collection: "animals", set: "white"  },             
        { sn: "04:d3:51:01:ec:44:03", type: "owl", collection: "animals", set: "white"  },             
        { sn: "04:90:31:01:ca:48:03", type: "baby chick", collection: "animals", set: "white"  },        
        { sn: "04:41:b6:01:1a:41:03", type: "sheep", collection: "animals", set: "white"  },             
        { sn: "04:f0:52:01:fe:49:03", type: "squirrel", collection: "animals", set: "white"  },        
        { sn: "04:d3:24:01:2c:44:03", type: "bear", collection: "animals", set: "white"  },             
        { sn: "04:d3:a7:01:50:44:03", type: "porcupine", collection: "animals", set: "white"  },        
        { sn: "04:41:79:01:57:41:03", type: "fox", collection: "animals", set: "white"  },                     
        { sn: "04:31:e2:01:7b:41:03", type: "penguin", collection: "animals", set: "white"  },             
        { sn: "04:80:0a:01:e7:48:03", type: "koala", collection: "animals", set: "white"  },                 
        { sn: "04:41:25:01:4c:41:03", type: "seal", collection: "animals", set: "white"  },                             

        /* treasure */        
        { sn: "04:35:6c:62:4a:6e:80", type: "treasure", collection: "treasure" }

    ];

    getCollection(collectionName, setName) {

        // First filter by collection name
        let result = this.tags.filter(item => item.collection === collectionName);
        
        // If setName is provided, filter further by set
        if (setName !== undefined) {
            result = result.filter(item => item.set === setName);
        }
        
        // Extract only the types and remove duplicates using Set
        const uniqueTypes = [...new Set(result.map(item => item.type))];
        
        return uniqueTypes;

    }

    constructor(parms) {

        this.startElementID = parms?.startElementID ?? null;
        this.fillElementID = parms?.fillElementID ?? null;
        this.hiddenElementID = parms?.hiddenElementID ?? null;

        // if startElement is null, create a scan button that we wait to press
        if(this.startElementID === null) {

            // set a flag so we can remove this button later
            this.scanButtonGenerated = true;

            const button = document.createElement('button');
            button.id = 'scanButton';
            button.textContent = 'Scan';
            document.body.appendChild(button);

            // save the ID of the button so we can hide it later
            this.startElementID = 'scanButton';

        }

        // in some cases, we might want to ensure that NFC scanning begins before
        // other user iteractions take place
        if(this.hiddenElementID) {
            
            // set the flag to indicate that the element is hidden
            this.hidden = true;

            // hide the element if it's not already hidden
            document.getElementById(this.hiddenElementID).style.display = "none";

        }

        if(window.config.debugDisableNFC == 1) {

            console.log('NFC use is disabled for debugging');

            return;

        }

        const startElement = document.getElementById(this.startElementID);
        startElement.addEventListener("click", async () => {

            // hide the beginButton
            //document.getElementById('beginButton').style.display = 'none';

            console.log("User clicked scan button");
          
            {
                const ndef = new NDEFReader();
                await ndef.scan();
                console.log("> Scan started");

                if(this.scanButtonGenerated === true) {

                    // hide the button now
                    document.getElementById(this.startElementID).style.display = "none";

                }

                // unhide the hidden element
                if(this.hiddenElementID != null) {

                    // unhide the specified element
                    document.getElementById(this.hiddenElementID).style.display = "block";

                    // clear the ID so we won't try to unhide again
                    this.hiddenElementID = null;

                }

                this.active = true;
            
                ndef.addEventListener("readingerror", () => {
                    //console.log("Argh! Cannot read data from the NFC tag. Try another one?");
                    alert("An NFC Tag Scan Error Occurred - Try Again");
                });

                // we'll have two modes of operating:
                // if fillElementID is specified, we'll fill that field with each new NFC tag
                // if fillElementID is null, we'll pass the tag to handleNFC() defined elsewhere
                if(this.fillElementID) {

                    ndef.addEventListener("reading", ({ message, serialNumber }) => {
                        //console.log(`> Serial Number: ${serialNumber}`);
                        //console.log(`> Records: (${message.records.length})`);
                
                        this.fillElement(message, serialNumber);
                    });

                } else {

                    ndef.addEventListener("reading", ({ message, serialNumber }) => {
                        //console.log(`> Serial Number: ${serialNumber}`);
                        //console.log(`> Records: (${message.records.length})`);
                
                        handleNFC(message, serialNumber);
                    });
                }

/*          
            } catch (error) {

                console.log("Error initializing NFC: " + error);
                this.active = false;
*/
            }
        }, { once: true });

        console.log('NFC Class Instantiated');

    }

    isActive() {

        return this.active;

    }

    fillElement(message, serialNumber) {

        document.getElementById(this.fillElementID).value = serialNumber;     

    }


    /*******************************************************************************
	function getTagBySerialNumber()
	
	Get the data stored for a tag matching a specific serial number.
		
	@param      {string} sn   the number of values to generate
	                  
	@returns    {Object|null}   Tag data if found, null if not found
		 
	******************************************************************************/	    
    getTagBySerialNumber(sn) {
        if (!sn || typeof sn !== 'string') {
            console.log(`getTagBySerialNumber() wasn't provided a string`);
            return null;
        }

        const tag = this.tags.find(tag => tag.sn === sn);

        return tag || null;

    } /* end getTagBySerialNumber() */

    /*******************************************************************************
	function getTagByType()
	
	Get all tags matching the specified type.
		
	@param      {string} type   the type of tag to retrieve
	                  
	@returns    {Object|null}   Tag data if found, null if not found
		 
	******************************************************************************/	    
    getTagByType(tagType) {
        if (!tagType || typeof tagType !== 'string') {
            console.log(`getTagByType() wasn't provided a string`);
            return null;
        }

        const tag = this.tags.find(tag => tag.type === tagType);

        return tag || null;

    } /* end getTagByType() */    

    /*******************************************************************************
	function getTagCollection()
	
	Get all tags from a specific collection.
		
	@param      {string} collection   type of collection to retrieve
	                  
	@returns    {Array|null}   array of tags matching this type
		 
	******************************************************************************/	        
    getTagCollection(collection) {

        if (!collection || typeof collection !== 'string') {
            console.log(`getTagCollection() wasn't provided a string`);
            return null;
        }

        return this.tags.filter(tag => tag.collection === collection);

    } /* end getTagCollection() */


    /**
     * Add a new tag to the collection
     * @param {Object} tag - Tag object to add
     * @returns {void}
     */
/*    
    addTag(tag) {
        if (!tag || typeof tag !== 'object') {
            throw new Error('Tag must be an object');
        }
        if (!tag.sn || !tag.type || !tag.collection) {
            throw new Error('Tag must have sn, type, and collection properties');
        }
        if (this.findBySN(tag.sn)) {
            throw new Error('Tag with this serial number already exists');
        }
        
        this.tags.push(tag);
    }
*/        
}

/*
// Usage example:
const tags = [
    { sn: "04:64:6b:62:4a:6e:80", type: "bunny", collection: "animals" },
    { sn: "04:b3:6b:62:4a:6e:80", type: "owl", collection: "animals" },
];

const nfc = new NFC(tags);

// Find by serial number
console.log(nfc.findBySN("04:64:6b:62:4a:6e:80"));
// Output: { sn: "04:64:6b:62:4a:6e:80", type: "bunny", collection: "animals" }

// Find all animals
console.log(nfc.findByCollection("animals"));
// Output: [both tags]

// Add a new tag
nfc.addTag({ 
    sn: "04:c1:6b:62:4a:6e:80", 
    type: "treasure", 
    collection: "items" 
});
*/